#include "WindowModule.h"
#include <iostream>
void window::WindowModule::start()
{
	super::start();
	const int WIDTH = 900;
	const int HEIGHT = 680;
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 4);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 0);
	SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
	m_window = SDL_CreateWindow("GrafattonDemo", SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED,
		WIDTH, HEIGHT, SDL_WINDOW_OPENGL | SDL_WINDOW_SHOWN | SDL_WINDOW_FULLSCREEN_DESKTOP);
	m_context = SDL_GL_CreateContext(m_window);

	SDL_GL_MakeCurrent(m_window, m_context);

	GLenum err = glewInit();
	if (GLEW_OK != err)
	{
		std::cout << glewGetErrorString(err);
		exit(1);
	}
	SDL_GL_SetSwapInterval(1);

	m_width = WIDTH;
	m_height = HEIGHT;

}

void window::WindowModule::stop()
{
	SDL_GL_DeleteContext(m_context);
	SDL_DestroyWindow(m_window);
	SDL_Quit();
	super::stop();
};

SDL_Window * window::WindowModule::getSDLWindow() {
	return m_window;
}